/*
 *  Inter-image Processing
 *  Mostly ripped off from Pete Battaglia (Fall 2009)
 *
 *  'm' to switch filters
 *  arrows pan
 *  PgUp/PgDn zooms in/out
 */
#include "CSCIx239.h"
int mode=0;         //  Filter to use
int axes=1;         //  Draw crosshairs
double asp=1;       //  Aspect ratio
double zoom=1;      //  Zoom factor
float frac=0;       //  Fraction
float X=0,Y=0;      //  Initial position
int shader;         //  Shader program
#define MODE 5
char* text[] = {"Image 0","Image 1","Mix","Difference","False Color"};

/*
 *  OpenGL (GLUT) calls this routine to display the scene
 */
void display()
{
   //  Erase the window and the depth buffer
   glClear(GL_COLOR_BUFFER_BIT);

   //  Set projection
   glLoadIdentity();
   Project(0,asp,1.0);

   //  Set up for drawing
   glPushMatrix();
   glScaled(zoom,zoom,1);
   glTranslated(X,Y,0);
   glColor3f(1,1,1);
   glUseProgram(shader);

   //  Set mode for shader
   int id = glGetUniformLocation(shader,"mode");
   if (id>=0) glUniform1i(id,mode);
   //  Fraction used in some filters
   id = glGetUniformLocation(shader,"frac");
   if (id>=0) glUniform1f(id,frac);
   //  First image is on texture unit 0
   id = glGetUniformLocation(shader,"img0");
   if (id>=0) glUniform1i(id,0);
   //  Second image is on texture unit 1
   id = glGetUniformLocation(shader,"img1");
   if (id>=0) glUniform1i(id,1);

   //  Draw to a quad
   glEnable(GL_TEXTURE_2D);
   glBegin(GL_QUADS);
   glTexCoord2f(0,0); glVertex2f(-1,-1);
   glTexCoord2f(0,1); glVertex2f(-1,+1);
   glTexCoord2f(1,1); glVertex2f(+1,+1);
   glTexCoord2f(1,0); glVertex2f(+1,-1);
   glEnd();
   glDisable(GL_TEXTURE_2D);

   //  Shader off
   glUseProgram(0);
   glPopMatrix();

   //  Draw crosshairs
   if (axes)
   {
      glBegin(GL_LINES);
      glVertex2f(-0.1,0);
      glVertex2f(+0.1,0);
      glVertex2f(0,-0.1);
      glVertex2f(0,+0.1);
      glEnd();
   }

   //  Display parameters
   glWindowPos2i(5,5);
   Print("Zoom=%.1f Offset=%f,%f Mode=%s",zoom,X,Y,text[mode]);
   if (mode==2) Print(" Fraction=%.1f",frac);
   //  Render the scene and make it visible
   ErrCheck("display");
   glFlush();
   glutSwapBuffers();
}

/*
 *  GLUT calls this routine when an arrow key is pressed
 */
void special(int key,int x,int y)
{
   //  Right arrow key - increase angle by 5 degrees
   if (key == GLUT_KEY_RIGHT)
      X -= 0.03/zoom;
   //  Left arrow key - decrease angle by 5 degrees
   else if (key == GLUT_KEY_LEFT)
      X += 0.03/zoom;
   //  Up arrow key - increase elevation by 5 degrees
   else if (key == GLUT_KEY_UP)
      Y -= 0.03/zoom;
   //  Down arrow key - decrease elevation by 5 degrees
   else if (key == GLUT_KEY_DOWN)
      Y += 0.03/zoom;
   //  PageUp key - increase zoom
   else if (key == GLUT_KEY_PAGE_DOWN)
      zoom /= 1.1;
   //  PageDown key - decrease zoom
   else if (key == GLUT_KEY_PAGE_UP)
      zoom *= 1.1;
   //  Limit zoom
   if (zoom<1)
   {
      zoom = 1;
      X = Y = 0;
   }
   //  Tell GLUT it is necessary to redisplay the scene
   glutPostRedisplay();
}

/*
 *  GLUT calls this routine when a key is pressed
 */
void key(unsigned char ch,int x,int y)
{
   //  Exit on ESC
   if (ch == 27)
      exit(0);
   //  Fraction
   else if (ch == '+')
      frac += 0.1;
   else if (ch == '-')
      frac -= 0.1;
   //  Reset view
   else if (ch == '0')
      X = Y = 0;
   //  Cycle modes
   else if (ch == 'm')
      mode = (mode+1)%MODE;
   else if (ch == 'M')
      mode = (mode+MODE-1)%MODE;
   //  Toggle axes
   else if (ch == 'a')
      axes = !axes;
   //  Limit fractions
   if (frac>1) frac = 1;
   if (frac<0) frac = 0;
   //  Tell GLUT it is necessary to redisplay the scene
   glutPostRedisplay();
}

/*
 *  GLUT calls this routine when the window is resized
 */
void reshape(int width,int height)
{
   //  Ratio of the width to the height of the window
   asp = (height>0) ? (double)width/height : 1;
   //  Set the viewport to the entire window
   glViewport(0,0, width,height);
}

/*
 *  Start up GLUT and tell it what to do
 */
int main(int argc,char* argv[])
{
   //  Initialize GLUT
   glutInit(&argc,argv);
   //  Request double buffered, true color window with Z buffering at 600x600
   glutInitDisplayMode(GLUT_RGB | GLUT_DEPTH | GLUT_DOUBLE);
   glutInitWindowSize(600,600);
   glutCreateWindow("Inter-mage Processing");
#ifdef USEGLEW
   //  Initialize GLEW
   if (glewInit()!=GLEW_OK) Fatal("Error initializing GLEW\n");
   if (!GLEW_VERSION_2_0) Fatal("OpenGL 2.0 not supported\n");
#endif
   //  Set callbacks
   glutDisplayFunc(display);
   glutReshapeFunc(reshape);
   glutSpecialFunc(special);
   glutKeyboardFunc(key);
   //  Load first image to texture unit 0
   glActiveTexture(GL_TEXTURE0);
   LoadTexBMP("20090602.bmp");
   //  Load second image to texture unit 1
   glActiveTexture(GL_TEXTURE1);
   LoadTexBMP("20090706.bmp");
   //  Set texture back to unit 0
   glActiveTexture(GL_TEXTURE0);
   //  One shader program does all the filters
   shader = CreateShaderProg(NULL,"imgproc.frag");
   //  Pass control to GLUT so it can interact with the user
   ErrCheck("init");
   glutMainLoop();
   return 0;
}
