//
//  Icosahedron class
//
#include "Icosahedron.h"

//
//  Constructor
//
Icosahedron::Icosahedron(const QString tex)
{
   sx = sy = sz = 1;
   if (tex.length()>0) setTexture(tex);
}

//
//  Set scaling
//
void Icosahedron::setScale(float dx,float dy,float dz)
{
   sx = dx;
   sy = dy;
   sz = dz;
}

//
//  Display the cube
//
void Icosahedron::display()
{
   if (!show) return;
   //  Save transformation
   glPushMatrix();
   //  Offset, scale and rotate
   useTransform(sx,sy,sz);
   //  Texture on
   EnableTex();
   //  Vertex coordinates, normals, textures and colors
   const float XNTC[] =
      {
       0.276, 0.851, 0.447,  0.471, 0.342, 0.761, 0.0,0.0, 0.0,0.0,1.0,
       0.894, 0.000, 0.447,  0.471, 0.342, 0.761, 1.0,0.0, 0.0,0.0,1.0,
       0.000, 0.000, 1.000,  0.471, 0.342, 0.761, 0.5,1.0, 0.0,0.0,1.0,
      -0.724, 0.526, 0.447, -0.180, 0.553, 0.761, 0.0,0.0, 0.0,1.0,0.0,
       0.276, 0.851, 0.447, -0.180, 0.553, 0.761, 1.0,0.0, 0.0,1.0,0.0,
       0.000, 0.000, 1.000, -0.180, 0.553, 0.761, 0.5,1.0, 0.0,1.0,0.0,
      -0.724,-0.526, 0.447, -0.582, 0.000, 0.762, 0.0,0.0, 0.0,1.0,1.0,
      -0.724, 0.526, 0.447, -0.582, 0.000, 0.762, 1.0,0.0, 0.0,1.0,1.0,
       0.000, 0.000, 1.000, -0.582, 0.000, 0.762, 0.5,1.0, 0.0,1.0,1.0,
       0.276,-0.851, 0.447, -0.180,-0.553, 0.761, 0.0,0.0, 1.0,0.0,1.0,
      -0.724,-0.526, 0.447, -0.180,-0.553, 0.761, 1.0,0.0, 1.0,0.0,1.0,
       0.000, 0.000, 1.000, -0.180,-0.553, 0.761, 0.5,1.0, 1.0,0.0,1.0,
       0.894, 0.000, 0.447,  0.471,-0.342, 0.761, 0.0,0.0, 1.0,1.0,0.0,
       0.276,-0.851, 0.447,  0.471,-0.342, 0.761, 1.0,0.0, 1.0,1.0,0.0,
       0.000, 0.000, 1.000,  0.471,-0.342, 0.761, 0.5,1.0, 1.0,1.0,0.0,
       0.000, 0.000,-1.000,  0.180, 0.553,-0.761, 0.0,0.0, 0.0,0.0,1.0,
       0.724, 0.526,-0.447,  0.180, 0.553,-0.761, 1.0,0.0, 0.0,0.0,1.0,
      -0.276, 0.851,-0.447,  0.180, 0.553,-0.761, 0.5,1.0, 0.0,0.0,1.0,
       0.000, 0.000,-1.000, -0.471, 0.342,-0.761, 0.0,0.0, 0.0,1.0,0.0,
      -0.276, 0.851,-0.447, -0.471, 0.342,-0.761, 1.0,0.0, 0.0,1.0,0.0,
      -0.894, 0.000,-0.447, -0.471, 0.342,-0.761, 0.5,1.0, 0.0,1.0,0.0,
       0.000, 0.000,-1.000, -0.471,-0.342,-0.761, 0.0,0.0, 0.0,1.0,1.0,
      -0.894, 0.000,-0.447, -0.471,-0.342,-0.761, 1.0,0.0, 0.0,1.0,1.0,
      -0.276,-0.851,-0.447, -0.471,-0.342,-0.761, 0.5,1.0, 0.0,1.0,1.0,
       0.000, 0.000,-1.000,  0.180,-0.553,-0.761, 0.0,0.0, 1.0,0.0,0.0,
      -0.276,-0.851,-0.447,  0.180,-0.553,-0.761, 1.0,0.0, 1.0,0.0,0.0,
       0.724,-0.526,-0.447,  0.180,-0.553,-0.761, 0.5,1.0, 1.0,0.0,0.0,
       0.000, 0.000,-1.000,  0.582, 0.000,-0.762, 0.0,0.0, 1.0,0.0,1.0,
       0.724,-0.526,-0.447,  0.582, 0.000,-0.762, 1.0,0.0, 1.0,0.0,1.0,
       0.724, 0.526,-0.447,  0.582, 0.000,-0.762, 0.5,1.0, 1.0,0.0,1.0,
       0.894, 0.000, 0.447,  0.761, 0.552, 0.180, 0.0,0.0, 1.0,1.0,0.0,
       0.276, 0.851, 0.447,  0.761, 0.552, 0.180, 1.0,0.0, 1.0,1.0,0.0,
       0.724, 0.526,-0.447,  0.761, 0.552, 0.180, 0.5,1.0, 1.0,1.0,0.0,
       0.276, 0.851, 0.447, -0.291, 0.894, 0.179, 0.0,0.0, 0.0,0.0,1.0,
      -0.724, 0.526, 0.447, -0.291, 0.894, 0.179, 1.0,0.0, 0.0,0.0,1.0,
      -0.276, 0.851,-0.447, -0.291, 0.894, 0.179, 0.5,1.0, 0.0,0.0,1.0,
      -0.724, 0.526, 0.447, -0.940, 0.000, 0.179, 0.0,0.0, 0.0,1.0,0.0,
      -0.724,-0.526, 0.447, -0.940, 0.000, 0.179, 1.0,0.0, 0.0,1.0,0.0,
      -0.894, 0.000,-0.447, -0.940, 0.000, 0.179, 0.5,1.0, 0.0,1.0,0.0,
      -0.724,-0.526, 0.447, -0.291,-0.894, 0.179, 0.0,0.0, 0.0,1.0,1.0,
       0.276,-0.851, 0.447, -0.291,-0.894, 0.179, 1.0,0.0, 0.0,1.0,1.0,
      -0.276,-0.851,-0.447, -0.291,-0.894, 0.179, 0.5,1.0, 0.0,1.0,1.0,
       0.276,-0.851, 0.447,  0.761,-0.552, 0.180, 0.0,0.0, 1.0,0.0,0.0,
       0.894, 0.000, 0.447,  0.761,-0.552, 0.180, 1.0,0.0, 1.0,0.0,0.0,
       0.724,-0.526,-0.447,  0.761,-0.552, 0.180, 0.5,1.0, 1.0,0.0,0.0,
       0.276, 0.851, 0.447,  0.291, 0.894,-0.179, 0.0,0.0, 1.0,0.0,1.0,
      -0.276, 0.851,-0.447,  0.291, 0.894,-0.179, 1.0,0.0, 1.0,0.0,1.0,
       0.724, 0.526,-0.447,  0.291, 0.894,-0.179, 0.5,1.0, 1.0,0.0,1.0,
      -0.724, 0.526, 0.447, -0.761, 0.552,-0.180, 0.0,0.0, 1.0,1.0,0.0,
      -0.894, 0.000,-0.447, -0.761, 0.552,-0.180, 1.0,0.0, 1.0,1.0,0.0,
      -0.276, 0.851,-0.447, -0.761, 0.552,-0.180, 0.5,1.0, 1.0,1.0,0.0,
      -0.724,-0.526, 0.447, -0.761,-0.552,-0.180, 0.0,0.0, 0.0,0.0,1.0,
      -0.276,-0.851,-0.447, -0.761,-0.552,-0.180, 1.0,0.0, 0.0,0.0,1.0,
      -0.894, 0.000,-0.447, -0.761,-0.552,-0.180, 0.5,1.0, 0.0,0.0,1.0,
       0.276,-0.851, 0.447,  0.291,-0.894,-0.179, 0.0,0.0, 0.0,1.0,0.0,
       0.724,-0.526,-0.447,  0.291,-0.894,-0.179, 1.0,0.0, 0.0,1.0,0.0,
      -0.276,-0.851,-0.447,  0.291,-0.894,-0.179, 0.5,1.0, 0.0,1.0,0.0,
       0.894, 0.000, 0.447,  0.940, 0.000,-0.179, 0.0,0.0, 0.0,1.0,1.0,
       0.724, 0.526,-0.447,  0.940, 0.000,-0.179, 1.0,0.0, 0.0,1.0,1.0,
       0.724,-0.526,-0.447,  0.940, 0.000,-0.179, 0.5,1.0, 0.0,1.0,1.0,
      };
   //  Define vertexes
   glVertexPointer(3,GL_FLOAT,11*sizeof(float),XNTC);
   glEnableClientState(GL_VERTEX_ARRAY);
   //  Define normals for each vertex
   glNormalPointer(GL_FLOAT,11*sizeof(float),XNTC+3);
   glEnableClientState(GL_NORMAL_ARRAY);
   //  Define texture coordinates for each vertex
   glTexCoordPointer(2,GL_FLOAT,11*sizeof(float),XNTC+6);
   glEnableClientState(GL_TEXTURE_COORD_ARRAY);
   //  Define colors for each vertex
   glColorPointer(3,GL_FLOAT,11*sizeof(float),XNTC+8);
   glEnableClientState(GL_COLOR_ARRAY);
   //  Draw icosahedron
   glDrawArrays(GL_TRIANGLES,0,60);
   //  Disable vertex array
   glDisableClientState(GL_VERTEX_ARRAY);
   //  Disable normal array
   glDisableClientState(GL_NORMAL_ARRAY);
   //  Disable texture array
   glDisableClientState(GL_TEXTURE_COORD_ARRAY);
   //  Disable color array
   glDisableClientState(GL_COLOR_ARRAY);

   //  Texture off
   DisableTex();
   //  Undo transofrmations
   glPopMatrix();
}




























































