// Fragment shader for drawing the Mandelbrot set
// Adapted from Orange book

varying vec2  ModelPos;
varying float LightIntensity;

// Center and zoom for mandelbrot set
uniform float Zoom;
uniform float Xcenter;
uniform float Ycenter;
// Maximum number of iterations
const float MaxIterations = 100.0;
//  Colors
const vec3  InnerColor  = vec3(0.0,0.0,0.0);
const vec3  OuterColor1 = vec3(1.0,0.0,0.0);
const vec3  OuterColor2 = vec3(0.0,1.0,0.0);

void main()
{
   //  Initialize
   float re  = ModelPos.x * Zoom + Xcenter;
   float im  = ModelPos.y * Zoom + Ycenter;
   float Cre = re;
   float Cim = im;

   //  Iterate
   float r2 = 0.0;
   float iter;
   for (iter=0.0 ; iter<MaxIterations && r2 < 4.0 ; iter++)
   {
       float re0 = re;
       re = re*re - im*im + Cre;
       im = 2.0*re0*im + Cim;
       r2   = re*re + im*im;
   }

   // Base the color on the number of iterations
   vec3 color = (r2 < 4.0) ? InnerColor : mix(OuterColor1,OuterColor2,fract(0.01*iter));
   color *= LightIntensity;
   gl_FragColor = vec4(color, 1.0);
}
