// Mandelbrot set vertex shader
// Identical to brick shader

//  Light intensity set by application program
//  We could have got this from gl_LightSource but use this
//  to demonstrate how to set user defined uniform variables
uniform float Ambient;
uniform float Diffuse;
//  Hardwire Specular intensity
const float Specular = 1.0;

//  Light intensity and model position required by fragment shader
varying float LightIntensity;
varying vec2  ModelPos;

void main()
{
   //  Phong shading light calculations
   //  See class slides for details
   //  This is done as a scalar here
   //  Component color stuff done in fragment shader

   //  P is the vertex coordinate on body
   vec3 P = vec3(gl_ModelViewMatrix * gl_Vertex);
   //  N is the object normal at P
   vec3 N = normalize(gl_NormalMatrix * gl_Normal);
   //  Light Position for light 0
   vec3 LightPos   = vec3(gl_LightSource[0].position);
   //  L is the light vector
   vec3 L = normalize(LightPos - P);
   //  R is the reflected light vector R = 2(L.N)N - L
   vec3 R = reflect(-L, N);
   //  V is the view vector (eye at the origin)
   vec3 V = normalize(-P);

   //  Diffuse light is cosine of light and normal vectors
   float diffuse   = max(dot(L,N) , 0.0);
   //  Specular is cosine of reflected and view vectors
   //  Shininess is hardwired to 16
   float specular = (diffuse>0.0) ? pow(max(dot(R,V) , 0.0) , 16.0) : 0.0;

   //  Scalar light intensity (for fragment shader)
   LightIntensity  = Ambient + diffuse*Diffuse + specular*Specular;

   //  Save model coordinates (for fragment shader)
   ModelPos        = gl_Vertex.xy;

   //  Return fixed transform coordinates for this vertex
   gl_Position     = ftransform();
}
