// Charles Gruenwald fragment shader

varying vec2  ModelPos;
varying float LightIntensity;

// Time in seconds
uniform float time;

void main()
{
   //  Running sine and cosine
   float S = ModelPos.x + sin(3.141*time);
   float C = ModelPos.y + cos(6.282*time);
   //  Compute color
   vec3 color;
   color.r = 0.1*(S*S - C*C);
   color.g = 0.1*(S*S + C*C);
   color.b = 0.1*(C*C - S*S);
   //  Adjust for lighting
   color *= LightIntensity;
   //  Pixel color
   gl_FragColor = vec4(color, 1.0);
}
