//
//  Hello Widget
//

#include <QtGui>
#include "viewer.h"
#include "lorenz.h"

//
//  Constructor for Viewer widget
//
Viewer::Viewer(QWidget* parent)
    :  QWidget(parent)
{
   //  Set window title
   setWindowTitle(tr("Qt OpenGL Lorenz Viewer"));

   //  Create new Lorenz widget
   Lorenz* lorenz = new Lorenz;

   //  Create spinboxes
   s   = new QDoubleSpinBox();
   b   = new QDoubleSpinBox();
   r   = new QDoubleSpinBox();
   dt  = new QDoubleSpinBox();
   dim = new QDoubleSpinBox();
   QDoubleSpinBox* x0  = new QDoubleSpinBox();
   QDoubleSpinBox* y0  = new QDoubleSpinBox();
   QDoubleSpinBox* z0  = new QDoubleSpinBox();

   //  Display widget for angles and dimension
   QLabel* angles = new QLabel();
   //  Pushbutton to reset view angle
   QPushButton* reset = new QPushButton("Reset Angle");

   //  Combo box to set s/b/r & dt values
   QComboBox* sbr = new QComboBox;
   sbr->addItems(QStringList() << "Set SBR, dt & dim"
      << "A:10.000,  2.666, 28.000, 0.001,  50"
      << "B:10.0  ,  2.67 , 15.000, 0.001,  25"
      << "C:10.0  ,  2.67 , 12.000, 0.001,  25"
      << "D: 4.086,  2.435,  7.767, 0.127,  25"
      << "E:10.642,  4.623,  7.354, 0.111,  25"
      << "F: 5.293,  3.211, 15.429, 0.023,  25"
      << "G:17.229,  8.929, 16.497, 0.044,  50"
      << "H:12.356,  3.031,  7.182, 0.098,  20"
      << "I:-1.7  ,  2.66 , 50.000, 0.003,  75"
      << "J:-1.0  ,  2.66 , 50.000, 0.003,  50"
      << "K:-3.0  ,  2.66 , 50.000, 0.003, 500");

   //  Set range and values
   s->setDecimals(1);   s->setSingleStep(1.0);      s->setRange(-10,50);          s->setValue(10);
   b->setDecimals(2);   b->setSingleStep(0.1);      b->setRange(0,50);            b->setValue(2.6);
   r->setDecimals(1);   r->setSingleStep(1.0);      r->setRange(0,50);            r->setValue(28);
   x0->setDecimals(1);  x0->setSingleStep(0.1);     x0->setRange(0.1,5.0);        x0->setValue(1.0);
   y0->setDecimals(1);  y0->setSingleStep(0.1);     y0->setRange(0.1,5.0);        y0->setValue(1.0);
   z0->setDecimals(1);  z0->setSingleStep(0.1);     z0->setRange(0.1,5.0);        z0->setValue(1.0);
   dt->setDecimals(4);  dt->setSingleStep(0.0001);  dt->setRange(0.0001,0.1000);  dt->setValue(0.001);
   dim->setDecimals(1); dim->setSingleStep(1);      dim->setRange(1,500);         dim->setValue(50);

   //  Connect valueChanged() signals to Lorenz
   connect(s     , SIGNAL(valueChanged(double)) , lorenz , SLOT(setS(double)));
   connect(b     , SIGNAL(valueChanged(double)) , lorenz , SLOT(setB(double)));
   connect(r     , SIGNAL(valueChanged(double)) , lorenz , SLOT(setR(double)));
   connect(x0    , SIGNAL(valueChanged(double)) , lorenz , SLOT(setX0(double)));
   connect(y0    , SIGNAL(valueChanged(double)) , lorenz , SLOT(setY0(double)));
   connect(z0    , SIGNAL(valueChanged(double)) , lorenz , SLOT(setZ0(double)));
   connect(dt    , SIGNAL(valueChanged(double)) , lorenz , SLOT(setDT(double)));
   connect(dim   , SIGNAL(valueChanged(double)) , lorenz , SLOT(setDIM(double)));
   connect(reset , SIGNAL(clicked(void))        , lorenz , SLOT(reset(void)));
   //  Connect lorenz signals to display widgets
   connect(lorenz , SIGNAL(angles(QString)) , angles , SLOT(setText(QString)));
   connect(lorenz , SIGNAL(dimen(double))   , dim    , SLOT(setValue(double)));
   //  Connect combo box to setSBR in myself
   connect(sbr , SIGNAL(currentIndexChanged(const QString&)), this , SLOT(setSBR(const QString&)));

   //  Set layout of child widgets
   QGridLayout* layout = new QGridLayout;
   layout->setColumnStretch(0,100);
   layout->setRowStretch(15,100);
   layout->addWidget(lorenz,0,0,16,1);
   layout->addWidget(new QLabel("s"),0,1);   layout->addWidget(s,0,2);
   layout->addWidget(new QLabel("b"),1,1);   layout->addWidget(b,1,2);
   layout->addWidget(new QLabel("r"),2,1);   layout->addWidget(r,2,2);
   layout->addWidget(new QLabel("x0"),4,1);  layout->addWidget(x0,4,2);
   layout->addWidget(new QLabel("y0"),5,1);  layout->addWidget(y0,5,2);
   layout->addWidget(new QLabel("z0"),6,1);  layout->addWidget(z0,6,2);
   layout->addWidget(new QLabel("dt"),8,1);  layout->addWidget(dt,8,2);
   layout->addWidget(new QLabel("Dim"),9,1); layout->addWidget(dim,9,2);
   layout->addWidget(new QLabel("Angle"),11,1);  layout->addWidget(angles,11,2);
   layout->addWidget(reset,12,1,1,2);
   layout->addWidget(sbr,14,1,1,2);
   setLayout(layout);
}

//
//  Set SBR, dt & dim in viewer
//
void Viewer::setSBR(const QString& str)
{
   QStringList SBR = str.mid(2).split(',');
   if (SBR.size()<5) return;
   s->setValue(SBR[0].toDouble());
   b->setValue(SBR[1].toDouble());
   r->setValue(SBR[2].toDouble());
   dt->setValue(SBR[3].toDouble());
   dim->setValue(SBR[4].toDouble());
}
